<?php if(isset($_SESSION["client_id"])):
$client = ClientData::getById($_SESSION["client_id"]);
$iva = ConfigurationData::getByPreffix("general_iva")->val;
$coin = ConfigurationData::getByPreffix("general_coin")->val;
$ivatxt = ConfigurationData::getByPreffix("general_iva_txt")->val;

?>

<?php

$buy = BuyData::getByCode($_GET["code"]);
$products = BuyProductData::getAllByBuyId($buy->id);
$ship = ShipData::getById($buy->ship_id);
?>
<div class="container">
<div class="row">

<div class="col-md-12">
<h3>Bienvenido, <?php echo $client->name." ".$client->lastname; ?></h3>
	<a href="./index.php?view=client" class="btn btn-secondary"><i class="fa fa-chevron-left"></i> Regresar</a>
	<a href="./invoice.php?code=<?php echo $buy->code;?>" target="_blank" class="btn btn-secondary"><i class="fa fa-file-o"></i> Imprimir</a>
</div>


</div>
</div>
<br>
<div class="container">
<div class="row">
	<div class="col-md-12">
<?php if($buy->status_id==1):?>
<p class="alert alert-warning">Operacion Pendiente</p>
<?php elseif($buy->status_id == 2 || $buy->status_id ==4 || $buy->status_id ==5 ):?>
<p class="alert alert-info"><?php echo StatusData::getById($buy->status_id)->name; ?></p>
<?php elseif($buy->status_id==3):?>
<p class="alert alert-danger">Operacion Cancelada</p>
<?php endif; ?>
	<h2> Compra #<?php echo $buy->id; ?></h2>
<?php if(count($products)>0):?>
<table class="table table-bordered">
	<thead>
		<th></th>
		<th>Cantidad</th>
		<th>Unidad</th>
		<th>Codigo</th>
		<th>Producto</th>
		<th>Total</th>
	</thead>
	<?php foreach($products as $p):
$px = $p->getProduct();
	?>
	<tr>
		<td><a href="index.php?view=producto&product_id=<?php echo $px->id; ?>" target="_blank" class="btn btn-default btn-xs">Detalles</a></td>
		<td><?php echo $p->q; ?></td>
		<td><?php echo $px->getUnit()->name; ?></td>
		<td><?php echo $px->code; ?></td>
		<td><?php echo $px->name; ?></td>
		<td><?php echo $coin; ?> <?php echo number_format($p->price*$p->q,2,".",","); ?></td>
	</tr>

	<?php endforeach; ?>
</table>

<?php
$total = $buy->getTotal();
?>
<div class="row">
<div class="col-md-5 col-md-offset-7">
	<table class="table table-bordered">
		<tr>
			<td>Envio</td><td><?php echo $coin; ?> <?php echo number_format($ship->price,2,".",","); ?></td>
		</tr>
		<tr>
			<td>Subtotal</td><td><?php echo $coin; ?> <?php echo number_format($buy->getTotal(),2,".",","); ?></td>
		</tr>
		<tr>
			<td><?php echo $ivatxt; ?></td><td><?php echo $coin; ?> <?php echo number_format($buy->getTotal()*($iva/100),2,".",","); ?></td>
		</tr>
		<?php if($buy->coupon_id!=null):
$coupon = CouponData::getById($buy->coupon_id);
		$discount = $coupon->val;
		$subtotal=$total+(($total*($iva/100)));
		$xdiscount=($subtotal )*($discount/100);
		?>
		<tr>
			<td>SubTotal</td><td><?php echo $coin; ?> <?php echo number_format($subtotal,2,".",","); ?></td>
		</tr>
		<tr>
			<td>Descuento: <b><?php echo $coupon->name." ($coupon->val%)";?></b></td><td><?php echo $coin; ?> <?php echo number_format($xdiscount,2,".",","); ?></td>
		</tr>
		<tr>
			<td>Total</td><td><?php echo $coin; ?> <?php echo number_format($subtotal-$xdiscount,2,".",","); ?></td>
		</tr>
		<tr>
			<td>Total+Envio</td><td><?php echo $coin; ?> <?php echo number_format(($subtotal-$xdiscount)+$ship->price,2,".",","); ?></td>
		</tr>

	<?php else:?>
		<tr>
			<td>Total</td><td><?php echo $coin; ?> <?php echo number_format($total+($total*($iva/100)),2,".",","); ?></td>
		</tr>
		<tr>
			<td>Total+Envio</td><td><?php echo $coin; ?> <?php echo number_format(($total+($total*($iva/100)))+$ship->price,2,".",","); ?></td>
		</tr>

	<?php endif; ?>
	</table>
<br>

<?php if($buy->status_id==1):?>
<form method="post" action="index.php?action=cancelbuy">
<input type="submit" class="btn btn-danger btn-block" value="Cancelar Compra">
<input type="hidden" name="buy_id" value="<?php echo $buy->id; ?>">
</form>
<?php endif; ?>
</div>
</div>
<br>
	<h2>Persona que recibe</h2>
<table class="table table-bordered">
	<thead>
		<th>Clave</th>
		<th>Valor</th>
	</thead>
	<tr>
		<td>Nombre</td>
		<td><?php echo $buy->person_name; ?></td>
	</tr>
	<tr>
		<td>Telefono</td>
		<td><?php echo $buy->person_phone; ?></td>
	</tr>
	<tr>
		<td>Direccion / Domicilio</td>
		<td><?php echo $buy->person_address; ?></td>
	</tr>
	<tr>
		<td>Ciudad</td>
		<td><?php echo $buy->person_city; ?></td>
	</tr>
	<tr>
		<td>Codigo Postal / Zip</td>
		<td><?php echo $buy->person_zip; ?></td>
	</tr>
</table>

<?php if($buy->paymethod_id==2):?>
	<h2>Datos del deposito bancario</h2>
<table class="table table-bordered">
	<thead>
		<th>Clave</th>
		<th>Valor</th>
	</thead>
	<tr>
		<td><?php echo ConfigurationData::getByPreffix("bank_titular")->label;?></td>
		<td><?php echo ConfigurationData::getByPreffix("bank_titular")->val;?></td>
	</tr>
	<tr>
		<td><?php echo ConfigurationData::getByPreffix("bank_name")->label;?></td>
		<td><?php echo ConfigurationData::getByPreffix("bank_name")->val;?></td>
	</tr>
	<tr>
		<td><?php echo ConfigurationData::getByPreffix("bank_account")->label;?></td>
		<td><?php echo ConfigurationData::getByPreffix("bank_account")->val;?></td>
	</tr>
	<tr>
		<td><?php echo ConfigurationData::getByPreffix("bank_card")->label;?></td>
		<td><?php echo ConfigurationData::getByPreffix("bank_card")->val;?></td>
	</tr>
</table>
<?php endif; ?>

<?php endif; ?>
	</div>
</div>
</div>



<?php endif; ?>
